<?php
$data['feature_types'] = array(
								'taxes' => array(
													'label' => __('Taxes', 'ihc'),
													'description' => __('Add additional tax charges which can be based on the user’s location by using the “Country” field', 'ihc'),
													'icon' => 'fa-taxes-ihc',
													'extra_class' => '',
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=taxes') : '',
													'enabled' => ihc_is_magic_feat_active('taxes'),
								),
								'opt_in' => array(
													'label' => __('Opt-in Settings', 'ihc'),
													'description' => __('Store your subscribers’ email address in a well known email marketing platform', 'ihc'),
													'icon' => 'fa-opt_in-ihc',
													'extra_class' => '',
													'link' => admin_url('admin.php?page=ihc_manage&tab=opt_in'),
													'enabled' => TRUE,
								),
								'woo_payment' => array(
													'label' => __('WooCommerce Payment Integration', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=woo_payment') : '',
													'icon' => 'fa-woo-ihc',
													'extra_class' => 'iump-woo-payment-special-color',
													'description' => '',
													'enabled' => ihc_is_magic_feat_active('woo_payment'),
								),
								'redirect_links' => array(
													'label' => __('Redirect Links', 'ihc'),
													'description' => __('Set custom links from inside or outside of your website that can be used for redirects inside the system', 'ihc'),
													'icon' => 'fa-links-ihc',
													'extra_class' => '',
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=redirect_links') : '',
													'enabled' => TRUE,
								),
								'bp_account_page' => array(
													'label' => __('BuddyPress Account Page Integration', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=bp_account_page') : '',
													'icon' => 'fa-bp-ihc',
													'extra_class' => '',
													'description' => '',
													'enabled' => ihc_is_magic_feat_active('bp_account_page'),
								),
								'woo_account_page' => array(
													'label' => __('WooCommerce Account Page Integration', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=woo_account_page') : '',
													'icon' => 'fa-woo-ihc',
													'extra_class' => '',
													'description' => '',
													'enabled' => ihc_is_magic_feat_active('woo_account_page'),
								),
								'membership_card' => array(
													'label' => __('Membership Card', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=membership_card') : '',
													'icon' => 'fa-membership_card-ihc',
													'extra_class' => '',
													'description' => __('Printable membership cards for assigned active levels', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('membership_card'),
								),
								'cheat_off' => array(
													'label' => __('Cheat Off', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=cheat_off') : '',
													'icon' => 'fa-cheat_off-ihc',
													'extra_class' => '',
													'description' => __('Prevent your customers from sharing their login credentials by keeping only one user logged in at a time', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('cheat_off'),
								),
								'invitation_code' => array(
													'label' => __('Invitation Code', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=invitation_code') : '',
													'icon' => 'fa-invitation_code-ihc',
													'extra_class' => '',
													'description' => __('Restrict register process to only allow invited users who have a valid code.', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('invitation_code'),
								),
								'download_monitor_integration' => array(
													'label' => __('Download Monitor Integration', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=download_monitor_integration') : '',
													'icon' => 'fa-download_monitor_integration-ihc',
													'extra_class' => '',
													'description' => __('Restrict the number of downloads based on subscription / levels', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('download_monitor_integration'),
								),
								'register_lite' => array(
													'label' => __('Register Lite', 'ihc'),
													'link' => admin_url('admin.php?page=ihc_manage&tab=register_lite'),
													'icon' => 'fa-register_lite-ihc',
													'extra_class' => '',
													'description' => __('Let your users register by using only their email address', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('register_lite'),
								),
								'individual_page' => array(
													'label' => __('Individual Page', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=individual_page') : '',
													'icon' => 'fa-individual_page-ihc',
													'extra_class' => '',
													'description' => __('Each user will have an individual page', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('individual_page'),
								),
								'woo_product_custom_prices' => array(
													'label' => __('WooCommerce Products Discount', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=woo_product_custom_prices') : '',
													'icon' => 'fa-woo-ihc',
													'extra_class' => 'iump-woo-discounts-special-color',
													'description' => '',
													'enabled' => ihc_is_magic_feat_active('woo_product_custom_prices'),
								),
								'level_restrict_payment' => array(
													'label' => __('Levels vs Payments', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=level_restrict_payment') : '',
													'icon' => 'fa-level_restrict_payment-ihc',
													'extra_class' => '',
													'description' => __('Restrict each level to be paid only through a specific payment gateway', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('level_restrict_payment'),
								),
								'level_subscription_plan_settings' => array(
													'label' => __('Levels Plus', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=level_subscription_plan_settings') : '',
													'icon' => 'fa-level_subscription_paln_settings-ihc',
													'extra_class' => '',
													'description' => __('Decide which levels should be available, based on the user’s current assigned level', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('level_subscription_plan_settings'),
								),
								'gifts' => array(
													'label' => __('Membership Gifts', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=gifts') : '',
													'icon' => 'fa-gifts-ihc',
													'extra_class' => '',
													'description' => __('Your customers will be able to buy “Levels” as gifts', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('gifts'),
								),
								'login_level_redirect' => array(
													'label' => __('Login Redirects+', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=login_level_redirect') : '',
													'icon' => 'fa-sign-in-ihc',
													'extra_class' => '',
													'description' => __('Set a custom redirect after login based on the user’s assigned level(s)', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('login_level_redirect'),
								),
								'wp_social_login' => array(
													'label' => __('Wp Social Login Integration', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=wp_social_login') : '',
													'icon' => 'fa-wp_social_login-ihc',
													'extra_class' => '',
													'description' => __('Integrated for a lite register/login with social accounts', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('wp_social_login'),
								),
								'list_access_posts' => array(
													'label' => __('List Access Posts', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=list_access_posts') : '',
													'icon' => 'fa-list_access_posts-ihc',
													'extra_class' => '',
													'description' => __('Display all the posts that a user can see based on his subscriptions', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('list_access_posts'),
								),
								'invoices' => array(
													'label' => __('Order Invoices', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=invoices') : '',
													'icon' => 'fa-invoices-ihc',
													'extra_class' => '',
													'description' => __('Provides printable invoices for each order in the account page or system dashboard', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('invoices'),
								),
								'custom_currencies' => array(
													'label' => __('Custom Currencies', 'ihc'),
													'description' => __('Add new currencies (with custom symbols) alongside the predefined list', 'ihc'),
													'icon' => 'fa-currencies-ihc',
													'extra_class' => '',
													'link' => admin_url('admin.php?page=ihc_manage&tab=custom_currencies'),
													'enabled' => TRUE,
								),
								'badges' => array(
													'label' => __('Membership Badges', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=badges') : '',
													'icon' => 'fa-badges-ihc',
													'extra_class' => '',
													'description' => __('Add a custom badge for each level for a better approach', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('badges'),
								),
								'login_security' => array(
													'label' => __('Security Login', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=login_security') : '',
													'icon' => 'fa-login_security-ihc',
													'extra_class' => '',
													'description' => __('Fight against brute-force attacks by blocking login for the IP after it reaches the maximum allowed retries', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('login_security'),
								),
								'workflow_restrictions' => array(
													'label' => __('WP Workflow Restrictions', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=workflow_restrictions') : '',
													'icon' => 'fa-workflow_restrictions-ihc',
													'extra_class' => '',
													'description' => __('Limit post views, WP post submissions, WP comments based on levels', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('workflow_restrictions'),
								),
								'subscription_delay' => array(
													'label' => __('Subscription Delay', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=subscription_delay') : '',
													'icon' => 'fa-subscription_delay-ihc',
													'extra_class' => '',
													'description' => __('Set a delay for each level’s start time', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('subscription_delay'),
								),

								'level_dynamic_price' => array(
													'label' => __('Level Dynamic Price', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=level_dynamic_price') : '',
													'icon' => 'fa-level_dynamic_price-ihc',
													'extra_class' => '',
													'description' => __('Mimic “Donations” by letting the client decide how much to pay for levels', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('level_dynamic_price'),
								),

								'user_reports' => array(
													'label' => __('User Reports', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=user_reports') : '',
													'icon' => 'fa-user_reports-ihc',
													'extra_class' => '',
													'description' => __('Follow the actions of the most important users', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('user_reports'),
								),

								'pushover' => array(
													'label' => __('Pushover Notifications', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=pushover') : '',
													'icon' => 'fa-pushover-ihc',
													'extra_class' => '',
													'description' => __('Users receive notifications on mobile via Pushover', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('pushover'),
								),

								'account_page_menu' => array(
													'label' => __('Account Custom Tabs', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=account_page_menu') : '',
													'icon' => 'fa-account_page_menu-ihc',
													'extra_class' => '',
													'description' => __('Create and reorder account page menu items', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('account_page_menu'),
								),

								'mycred' => array(
													'label' => __('MyCred Points', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=mycred') : '',
													'icon' => 'fa-mycred-ihc',
													'extra_class' => '',
													'description' => __('Reward with myCred points when a subscription is purchased', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('mycred'),
								),

								'api' => array(
													'label' => __('API Gate', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=api') : '',
													'icon' => 'fa-api-ihc',
													'extra_class' => '',
													'description' => __('Manage UMP details via API module', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('api'),
								),

								'drip_content_notifications' => array(
													'label' => __('Drip Content Notifications', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=drip_content_notifications') : '',
													'icon' => 'fa-drip_content_notifications-ihc',
													'extra_class' => 'iump-dripcontentnotifications-special-color',
													'description' => __('Alert members when a new post is released by “Drip Content”', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('drip_content_notifications'),
								),

								'user_sites' => array(
													'label' => __('MultiSite Subscriptions', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=user_sites') : '',
													'icon' => 'fa-user_sites-ihc',
													'extra_class' => '',
													'description' => __('Provides “SingleSites” based on purchased subscriptions', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('user_sites'),
								),

								'import_users' => array(
													'label' => __('Import Users&Levels', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=import_users') : '',
													'icon' => 'fa-import_users-ihc',
													'extra_class' => '',
													'description' => __('Import and update main users’ details and levels', 'ihc'),
													'enabled' => TRUE,
								),

								'register_redirects_by_level' => array(
													'label' => __('Register Redirects+', 'ihc'),
													'link' => (IHCACTIVATEDMODE) ? admin_url('admin.php?page=ihc_manage&tab=register_redirects_by_level') : '',
													'icon' => 'fa-register_redirects_by_level-ihc',
													'extra_class' => '',
													'description' => __('Set a custom redirect after register based on the user’s assigned level(s)', 'ihc'),
													'enabled' => ihc_is_magic_feat_active('register_redirects_by_level'),
								),
);
foreach ($data['feature_types'] as $k=>$v):?>
	<div class="ihc-magic-box-wrap <?php echo ($v['enabled']) ? '' : 'ihc-disabled-box';?>">
		<a href="<?php echo $v['link'];?>">
			<div class="ihc-magic-feature <?php echo $k;?> <?php echo $v['extra_class'];?>">
				<div class="ihc-magic-box-icon"><i class="fa-ihc <?php echo $v['icon'];?>"></i></div>
				<div class="ihc-magic-box-title"><?php echo $v['label'];?></div>
				<div class="ihc-magic-box-desc"><?php echo $v['description'];?></div>
			</div>
		</a>
	</div>
<?php endforeach;?>
